/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.server.IPECommands;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class VWApplicationSpaceDefinition
extends VWMLABase
implements Serializable,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 7461L;
    protected int revision = 0;
    protected String m_name = null;
    private String m_description = null;
    protected String[] m_writeSecurity = null;
    private VWParticipant[] m_writeSecurityPx = null;
    private VWRoleDefinition[] m_roleDefs = new VWRoleDefinition[0];
    private VWArrayHandler m_roleDefHandler = new VWArrayHandler();
    private VWRoleDefinition[] m_deletedRoleDefs = new VWRoleDefinition[0];
    private VWArrayHandler m_deletedRoleDefHandler = new VWArrayHandler();
    protected Hashtable m_attributes = null;
    private boolean m_bHasChanged = false;
    private int m_nObjId = -1;
    protected boolean isSelectedForExport = true;

    public static String _get_FILE_DATE() {
        return "$Date: 2011-01-19 23:56:37 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    protected VWApplicationSpaceDefinition(int revision, String name, String description) throws VWException {
        this.revision = revision;
        this.setName(name);
        this.m_description = description;
        this.setHasChanged(true);
    }

    public int getRevision() throws VWException {
        return this.revision;
    }

    public String getName() {
        return this.translateStr(this.m_name);
    }

    public String getAuthoredName() throws VWException {
        return this.translateToAuthored(this.m_name);
    }

    public String getDescription() {
        if (this.m_description != null) {
            return this.translateStr(this.m_description);
        }
        return null;
    }

    public void setDescription(String description) throws VWException {
        this.m_description = description;
        this.setHasChanged(true);
    }

    public String[] getWriteSecurity() throws VWException {
        if (this.m_writeSecurity != null) {
            return this.m_writeSecurity;
        }
        this.m_writeSecurity = this.convertSecurityPxtoSecurity(this.m_writeSecurityPx);
        return this.m_writeSecurity;
    }

    public VWParticipant[] getWriteSecurityPx() throws VWException {
        return this.m_writeSecurityPx;
    }

    public void setWriteSecurityPx(VWParticipant[] newWriteSecurityPx) throws VWException {
        this.m_writeSecurity = null;
        this.m_writeSecurityPx = newWriteSecurityPx;
        this.setHasChanged(true);
    }

    public VWRoleDefinition getRoleDefinition(String roleName) throws VWException {
        if (roleName == null || roleName.trim().length() == 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.GetRoleDeleteWithNullName", "Cannot get a role with a null or empty name");
        }
        if (this.m_roleDefs == null || this.m_roleDefs.length == 0) {
            return null;
        }
        VWRoleDefinition result = null;
        String tmpdefName = null;
        String tmpdefAuthoredName = null;
        if (this.m_roleDefs != null) {
            for (int i = 0; i < this.m_roleDefs.length; ++i) {
                if (this.m_roleDefs[i] == null) continue;
                tmpdefName = this.m_roleDefs[i].getName();
                tmpdefAuthoredName = this.m_roleDefs[i].getAuthoredName();
                if ((tmpdefName == null || !roleName.equals(tmpdefName)) && (tmpdefAuthoredName == null || !roleName.equals(tmpdefAuthoredName))) continue;
                result = this.m_roleDefs[i];
                break;
            }
        }
        return result;
    }

    public VWRoleDefinition[] getRoleDefinitions() throws VWException {
        if (this.m_roleDefHandler.getElementCount() > 0) {
            return (VWRoleDefinition[])this.m_roleDefHandler.getElements(this.m_roleDefs);
        }
        return null;
    }

    public VWRoleDefinition createRoleDefinition(String roleName) throws VWException {
        return this.createRoleDefinition(roleName, 0);
    }

    protected VWRoleDefinition createRoleDefinition(String roleName, int revision) throws VWException {
        if (roleName == null || roleName.trim().length() == 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.CreateRoleDeleteWithNullName", "Cannot create a role with a null or empty name");
        }
        int nIndex = this.m_roleDefHandler.getIndexFromStringFieldValue(this.m_roleDefs, "m_name", roleName);
        if (nIndex != -1) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.roleAlreadyExists", "A role definition with that name already exists.");
        }
        VWRoleDefinition newRoleDef = new VWRoleDefinition(revision, roleName, this);
        this.m_roleDefs = (VWRoleDefinition[])this.m_roleDefHandler.addElementToArray(this.m_roleDefs, newRoleDef);
        this.setHasChanged(true);
        return newRoleDef;
    }

    public VWRoleDefinition deleteRoleDefinition(String roleName) throws VWException {
        if (roleName == null || roleName.trim().length() == 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.RoleDeleteWithNullName", "Cannot delete a role with a null or empty name");
        }
        int nIndex = this.m_roleDefHandler.getIndexFromStringFieldValue(this.m_roleDefs, "m_name", roleName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.roleNotFound", "No role found with name equal to \"{0}\".", roleName);
        }
        VWRoleDefinition roleDef = this.m_roleDefs[nIndex];
        this.m_roleDefHandler.deleteElementFromArray(this.m_roleDefs, nIndex);
        if (roleDef.getObjId() != -1) {
            this.m_deletedRoleDefs = (VWRoleDefinition[])this.m_deletedRoleDefHandler.addElementToArray(this.m_deletedRoleDefs, roleDef);
        } else {
            roleDef.removeReferences();
        }
        this.setHasChanged(true);
        return roleDef;
    }

    public VWRoleDefinition createCopyOfRoleDefinition(String roleName, VWRoleDefinition origRoleDef) throws VWException {
        if (roleName == null || roleName.trim().length() == 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.createCopyRoleDeleteWithNullName", "The destination role name can not be null or empty");
        }
        if (origRoleDef == null) {
            throw new VWException("vw.api.VWApplicationSpaceDefinition.NullSourceRoleDefinition", "The source role definition is null.");
        }
        VWRoleDefinition newRoleDef = (VWRoleDefinition)origRoleDef.clone();
        if (newRoleDef != null) {
            newRoleDef.setName(roleName);
            newRoleDef.setObjId(0);
            newRoleDef.m_nRevision = 0;
        }
        this.m_roleDefs = (VWRoleDefinition[])this.m_roleDefHandler.addElementToArray(this.m_roleDefs, newRoleDef);
        this.setHasChanged(true);
        return newRoleDef;
    }

    public void updateRoleDefinition(VWRoleDefinition theRoleDefinition) throws VWException {
        if (theRoleDefinition == null) {
            throw new VWException("vw.api.VWApplicationSpace.UpdateDefRoleDefNull", "Can not update a null role definition");
        }
        int theIndex = this.m_roleDefHandler.getIndexFromStringFieldValue(this.m_roleDefs, "m_name", theRoleDefinition.getName());
        if (theIndex == -1) {
            throw new VWException("vw.api.VWApplicationSpaceRoleDoesNotExist", "The role definition does not exist.");
        }
        this.m_roleDefHandler.replaceElementInArray(this.m_roleDefs, theRoleDefinition, theIndex);
        this.setHasChanged(true);
    }

    public Object clone() {
        try {
            int i;
            VWRoleDefinition roleDef;
            VWApplicationSpaceDefinition appSpaceDef = (VWApplicationSpaceDefinition)super.clone();
            try {
                appSpaceDef.m_roleDefHandler = new VWArrayHandler();
                appSpaceDef.m_roleDefs = new VWRoleDefinition[0];
                if (this.m_roleDefs != null) {
                    roleDef = null;
                    for (i = 0; i < this.m_roleDefs.length; ++i) {
                        if (this.m_roleDefs[i] == null) continue;
                        roleDef = (VWRoleDefinition)this.m_roleDefs[i].clone();
                        roleDef.setMyApplicationSpaceDefinition(appSpaceDef);
                        appSpaceDef.m_roleDefs = (VWRoleDefinition[])appSpaceDef.m_roleDefHandler.addElementToArray(appSpaceDef.m_roleDefs, roleDef);
                    }
                }
            }
            catch (VWException ex) {
                // empty catch block
            }
            try {
                appSpaceDef.m_deletedRoleDefHandler = new VWArrayHandler();
                appSpaceDef.m_deletedRoleDefs = new VWRoleDefinition[0];
                if (this.m_deletedRoleDefs != null) {
                    roleDef = null;
                    for (i = 0; i < this.m_deletedRoleDefs.length; ++i) {
                        if (this.m_roleDefs[i] == null) continue;
                        roleDef = (VWRoleDefinition)this.m_deletedRoleDefs[i].clone();
                        roleDef.setMyApplicationSpaceDefinition(appSpaceDef);
                        appSpaceDef.m_deletedRoleDefs = (VWRoleDefinition[])appSpaceDef.m_deletedRoleDefHandler.addElementToArray(appSpaceDef.m_deletedRoleDefs, roleDef);
                    }
                }
            }
            catch (VWException vWException) {
                // empty catch block
            }
            if (this.m_attributes != null) {
                appSpaceDef.m_attributes = (Hashtable)this.m_attributes.clone();
            }
            if (this.m_writeSecurityPx != null) {
                appSpaceDef.setWriteSecurityPx((VWParticipant[])this.m_writeSecurityPx.clone());
                if (this.m_writeSecurity != null) {
                    appSpaceDef.m_writeSecurity = (String[])this.m_writeSecurity.clone();
                }
            }
            return appSpaceDef;
        }
        catch (CloneNotSupportedException cnsEx) {
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return this.m_name;
    }

    public int getObjId() throws VWException {
        return this.m_nObjId;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    public boolean hasChanged() throws VWException {
        return this.m_bHasChanged;
    }

    protected void setHasChanged(boolean theNewValue) {
        this.m_bHasChanged = theNewValue;
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.m_attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
        this.setHasChanged(true);
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.m_attributes);
    }

    protected void setName(String theName) throws VWException {
        if (theName != null) {
            theName = theName.trim();
        }
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefinitionInvalidName", "The application space name is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_name)) {
            return;
        }
        if (theName.length() > 128) {
            throw new VWException("vw.api.VWApplicationSpaceDefinitionNameTooLong", "The application space name can not exceed 128 characters).");
        }
        if (theName.startsWith("~")) {
            throw new VWException("vw.api.VWApplicationSpaceDefinitionName.InvalidSartChar", "The application space name can not start with ''~''.");
        }
        this.m_name = theName;
        this.setHasChanged(true);
    }

    protected IPECommands getCmdSession() throws VWException {
        if (this.getSession() != null) {
            return this.getSession().getCmdSession();
        }
        return null;
    }

    protected VWSession getVWSession() throws VWException {
        return super.getSession();
    }

    protected void setObjId(int theNewObjId) throws VWException {
        if (theNewObjId < 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefObjIdErr", "The object id can not be a negative value.");
        }
        this.m_nObjId = theNewObjId;
        this.setHasChanged(true);
    }

    protected void setRevision(int theRevision) throws VWException {
        if (theRevision < 0) {
            throw new VWException("vw.api.VWApplicationSpaceDefRevisionErr", "The revision can not be a negative value.");
        }
        this.revision = theRevision;
        this.setHasChanged(true);
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.m_attributes = theAttributes;
    }

    protected String[] convertSecurityPxtoSecurity(VWParticipant[] securityPx) {
        if (securityPx == null) {
            return null;
        }
        int sz = securityPx == null ? 0 : securityPx.length;
        Vector<String> securityCol = new Vector<String>(sz);
        for (int i = 0; i < sz; ++i) {
            if (securityPx[i] == null) continue;
            securityCol.add(securityPx[i].getParticipantName());
        }
        return securityCol.toArray(new String[0]);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (!this.isSelectedForExport) {
            return;
        }
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAppliationSpaceDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "ApplicationSpaceDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.m_name) + "\"\n");
        theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.m_description) + "\"\n");
        theBuffer.append(INDENT_1 + "Revision" + "=\"" + this.getRevision() + "\"\n");
        int nObjId = this.getObjId();
        if (nObjId >= 0) {
            theBuffer.append(INDENT_1 + "ObjectId" + "=\"" + nObjId + "\"");
        }
        theBuffer.append(">\n");
        this.getRoleDefinitions();
        if (this.m_roleDefs != null) {
            theBuffer.append(INDENT_1 + "<" + "ArrayOfRoleDefinition" + ">\n");
            if (this.m_roleDefs != null && this.m_roleDefs.length > 0) {
                for (int i = 0; i < this.m_roleDefs.length; ++i) {
                    if (this.m_roleDefs[i] == null) continue;
                    this.m_roleDefs[i].toXML(theBuffer, INDENT_2);
                }
            }
            theBuffer.append(INDENT_1 + "</" + "ArrayOfRoleDefinition" + ">\n");
        }
        theBuffer.append(INDENT_1 + "<" + "WriteSecurity" + ">\n");
        String[] wSecurityList = this.getWriteSecurity();
        if (wSecurityList != null && wSecurityList.length > 0) {
            for (int i = 0; i < wSecurityList.length; ++i) {
                if (wSecurityList[i] == null) continue;
                theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(wSecurityList[i]) + "</" + "Value" + ">\n");
            }
        }
        theBuffer.append(INDENT_1 + "</" + "WriteSecurity" + ">\n");
        VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
        theAttributeInfo.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_0 + "</" + "ApplicationSpaceDefinition" + ">\n");
    }

    protected VWRoleDefinition[] getDeletedRoleDefinitions() throws VWException {
        if (this.m_deletedRoleDefHandler.getElementCount() > 0) {
            return (VWRoleDefinition[])this.m_deletedRoleDefHandler.getElements(this.m_deletedRoleDefs);
        }
        return null;
    }

    protected void initWorkBasketDefsForRoleDefs(VWSystemConfiguration sysConfig) {
        try {
            VWRoleDefinition[] roleDefs = this.getRoleDefinitions();
            if (roleDefs != null && roleDefs.length > 0) {
                for (int i = 0; i < roleDefs.length; ++i) {
                    if (roleDefs[i] == null) continue;
                    roleDefs[i].initWorkBasketDefsFromOrb(sysConfig);
                    roleDefs[i].setMyApplicationSpaceDefinition(this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setIsSelectedForExport(boolean selectIt) {
        this.isSelectedForExport = selectIt;
    }

    protected boolean getIsSelectedForExport() {
        return this.isSelectedForExport;
    }

    public String[] getReadSecurity() throws VWException {
        return null;
    }

    public VWParticipant[] getReadSecurityPx() throws VWException {
        return null;
    }

    public void setReadSecurityPx(VWParticipant[] newReadSecurityPx) throws VWException {
    }
}

